# to autoload this file
proc m2AdjPrefs.tcl {} {}


#===========================================================================
#  Adjusting preferences after F12-Configuration  #
#===========================================================================
# The following proc serve to adjust the M2 preferences variables once 
# the user has edited them via the menu "Config > Current Mode > Preferences..."
# This ensures that the latest settings are preserved from one session to the 
# next and need not to be reconfigured each time you relaunch Alpha

proc adjustAuthor {varName} {
	global M2modeVars
	global M2Author
	# alertnote "in adjustAuthor"
	set M2Author "$M2modeVars($varName)"
	prefs::modified M2Author
}

proc adjustShellLaunching {varName} {
	global M2modeVars
	global M2TokenFile
	global M2ShellName
	global M2ShellHome
	global M2ErrFile
	# alertnote "in adjustShellLaunching"
	set M2ShellName "$M2modeVars($varName)"
	set M2ShellHome [file dirname $M2ShellName]
	set M2TokenFile [file join $M2ShellHome token.ALPHA]
	set M2ErrFile [file join $M2ShellHome err.ALPHA]
	prefs::modified M2ShellName M2ShellHome M2TokenFile M2ErrFile
}

proc adjustErrDOKFile {varName} {
	global M2modeVars
	global M2errDOKFile
	# alertnote "in adjustErrDOKFile"
	set M2errDOKFile "$M2modeVars($varName)"
	prefs::modified M2errDOKFile
}

proc adjustRShiftAmount {varName} {	
	global M2modeVars
	global M2RightShift
	global duringAutoConfiguration
	# alertnote "in adjustRShiftAmount"
	if {[info exists M2RightShift]} then {
		set oldM2RightShift $M2RightShift
	} else {
		set oldM2RightShift "$M2modeVars($varName)"
	}
	set M2RightShift "$M2modeVars($varName)"
	prefs::modified M2RightShift
	if {[info exists duringAutoConfiguration] && ($duringAutoConfiguration)} then { return }
	if {$oldM2RightShift != $M2RightShift} then {
		defineM2Completions
	}
}

proc adjustLShiftAmount {varName} {
	global M2modeVars
	global M2LeftShift
	# alertnote "in adjustLShiftAmount"
	set M2LeftShift "$M2modeVars($varName)"
	prefs::modified M2LeftShift
}

proc adjustRightMargin {varName} {
	global M2modeVars
	global M2WrapRightMargin
	# alertnote "in adjustRightMargin"
	set M2WrapRightMargin "$M2modeVars($varName)"
	prefs::modified M2WrapRightMargin
}

proc adjustMaxLnLength {varName} {
	global M2modeVars
	global M2MaxLineLength
	# alertnote "in adjustMaxLnLength"
	set M2MaxLineLength "$M2modeVars($varName)"
	prefs::modified M2MaxLineLength
	setLnBreakBehavior $M2MaxLineLength
}

 proc adjustMaxLnLeTolerance {varName} {
	global M2modeVars
	global M2MaxLineLength
	# alertnote "in adjustMaxLnLeTolerance"
	# is a simple newPref variable and its value is not remembered
	setLnBreakBehavior $M2MaxLineLength
}

proc adjustSavedState {varName} {
	global M2modeVars
	global M2SaveState
	# alertnote "in adjustSavedState"
	set M2SaveState "$M2modeVars($varName)"
	prefs::modified M2SaveState
}

proc adjustSpaceBarExpansion {varName} {
    global M2modeVars
    # alertnote "in adjustSpaceBarExpansion"
    if $M2modeVars($varName) {
	# Space bar (may trigger template)
	Bind 0x31     modulaSpace         "M2" 
    } else {
	# Space bar no longer triggers template
	unBind 0x31   modulaSpace         "M2" 
    }
}
	
proc adjustCommentChars {varName} {
    global M2::commentCharacters M2modeVars
    set M2::commentCharacters(General) "$M2modeVars(prefixString)"
    set M2::commentCharacters(Paragraph) [list "$M2modeVars(prefixString)" "$M2modeVars(suffixString)" ""]
    
    set boxBeg [string trim $M2modeVars(prefixString)]
    set boxBegLe [string length $boxBeg]
    set boxEnd [string trim $M2modeVars(suffixString)]
    set boxEndLe [string length $boxEnd]
    set M2::commentCharacters(Box) [list "$boxBeg" $boxBegLe "$boxEnd" $boxEndLe "\*" 3]
}

set whileAdjusting 0

proc adjustM2Prefs {varName} {
    global whileAdjusting M2modeVars
    set whileAdjusting 1
    if {[catch {
	switch -- $varName {
	    "m2_author" { adjustAuthor "$varName" }
	    "m2_shellName" { adjustShellLaunching "$varName" }
	    "m2_errListDOK" { adjustErrDOKFile "$varName" }
	    "m2_indentAmount" { adjustRShiftAmount "$varName" }
	    "m2_leftShiftAmount" { adjustLShiftAmount "$varName" }
	    "m2_fillRightMargin" { adjustRightMargin "$varName" }
	    "m2_maxLineLength" { adjustMaxLnLength "$varName" }
	    "m2_maxLnLeTol" { adjustMaxLnLeTolerance "$varName" }
	    "m2_savedState" { adjustSavedState "$varName" }
	    "spaceBarExpansion" { adjustSpaceBarExpansion "$varName" }
	    "prefixString" { adjustCommentChars "$varName" }
	    "suffixString" { adjustCommentChars "$varName" }
	}
    } err]} {
	alertnote "M2 mode error '$err' in adjustM2Prefs"
    }
    set whileAdjusting 0
    # alertnote "In adjustM2Prefs: varName = '$varName'"
}


# This procedure sources the completions, which is necessary to do again as soon
# as user changes M2RightShift. Make sure variable scope includes ALL variables
# needed by the ENTIRE script M2Completions.tcl!
proc defineM2Completions {} {
    global HOME
    # alertnote "In defineM2Completions"
    set completionsFileName [file join $HOME Tcl Completions M2Completions.tcl]
    if {[file exists "$completionsFileName"]} then {
	uplevel \#0 [list source $completionsFileName]
    }
}



# Reporting that end of this script has been reached
message "m2AdjPrefs.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
	alertnote "m2AdjPrefs.tcl for Programing in Modula-2 loaded"
}
